/*
 * Decompiled with CFR 0.152.
 */
package com.sleelin.pvptoggle;

import com.sleelin.pvptoggle.PvPLocalisation;
import com.sleelin.pvptoggle.PvPToggle;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PvPCommandHandler
implements CommandExecutor {
    private final PvPToggle plugin;

    public PvPCommandHandler(PvPToggle instance) {
        this.plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (args.length == 0) {
            if (player != null) {
                this.togglePlayer(sender, player, player.getWorld().getName(), !this.plugin.checkPlayerStatus(player, player.getWorld().getName()));
            } else {
                this.getGlobalStatus(sender);
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("on") || args[0].equalsIgnoreCase("enable") || args[0].equalsIgnoreCase("off") || args[0].equalsIgnoreCase("disable")) {
            switch (args.length) {
                case 1: {
                    if (player != null) {
                        this.togglePlayer(sender, player, player.getWorld().getName(), PvPCommandHandler.checkNewValue(args[0]));
                        break;
                    }
                    PvPLocalisation.display(sender, "", "", "", PvPLocalisation.Strings.CONSOLE_ERROR);
                    break;
                }
                case 2: {
                    Player retrieved = this.getPlayer(sender, args[1], true);
                    if (retrieved == null) break;
                    this.togglePlayer(sender, retrieved, retrieved.getWorld().getName(), PvPCommandHandler.checkNewValue(args[0]));
                    break;
                }
                case 3: {
                    this.togglePlayer(sender, this.getPlayer(sender, args[1], true), this.isWorld(sender, args[2]), PvPCommandHandler.checkNewValue(args[0]));
                    break;
                }
                default: {
                    this.sendUsage(sender, "toggle");
                }
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("status") || args[0].equalsIgnoreCase("s")) {
            switch (args.length) {
                case 1: {
                    if (player != null) {
                        this.getPlayerStatus(sender, player, player.getWorld().getName());
                        break;
                    }
                    this.getGlobalStatus(sender);
                    break;
                }
                case 2: {
                    Player retrieved = this.getPlayer(sender, args[1], true);
                    if (retrieved == null) break;
                    this.getPlayerStatus(sender, retrieved, retrieved.getWorld().getName());
                    break;
                }
                case 3: {
                    this.getPlayerStatus(sender, this.getPlayer(sender, args[1], true), this.isWorld(sender, args[2]));
                    break;
                }
                default: {
                    this.sendUsage(sender, "status");
                }
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("reset") || args[0].equalsIgnoreCase("r")) {
            switch (args.length) {
                case 2: {
                    this.resetPlayer(sender, this.getPlayer(sender, args[1], true), "*");
                    break;
                }
                case 3: {
                    this.resetPlayer(sender, this.getPlayer(sender, args[1], true), this.isWorld(sender, args[2]));
                    break;
                }
                default: {
                    this.sendUsage(sender, "reset");
                }
            }
            return true;
        }
        if (args[0].startsWith("w:") || args[0].equalsIgnoreCase("world") || args[0].equalsIgnoreCase("w")) {
            String worldname = null;
            String action = args[args.length - 1];
            if (args[0].startsWith("w:")) {
                worldname = this.isWorld(sender, args[0].substring(2));
            } else if (args.length > 1) {
                worldname = this.isWorld(sender, args[1]);
            } else {
                this.sendUsage(sender, "world");
            }
            if (worldname != null) {
                if (action.equalsIgnoreCase("status") || worldname.equalsIgnoreCase(action) || worldname.equalsIgnoreCase(action.substring(2)) && action.startsWith("w:")) {
                    this.getWorldStatus(sender, worldname);
                } else if (action.equalsIgnoreCase("reset")) {
                    this.resetWorld(sender, worldname, this.plugin.getWorldDefault(worldname));
                } else if (action.equalsIgnoreCase("on") || action.equalsIgnoreCase("off")) {
                    this.toggleWorld(sender, worldname, PvPCommandHandler.checkNewValue(action));
                } else {
                    this.sendUsage(sender, "world");
                }
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("global") || args[0].equalsIgnoreCase("g")) {
            if (args.length == 2) {
                if (args[1].equalsIgnoreCase("status")) {
                    this.getGlobalStatus(sender);
                } else if (args[1].equalsIgnoreCase("reset")) {
                    this.resetGlobal(sender);
                } else if (PvPCommandHandler.checkNewValue(args[1]) != null) {
                    this.toggleGlobal(sender, PvPCommandHandler.checkNewValue(args[1]));
                } else {
                    this.sendUsage(sender, "global");
                }
            } else {
                this.getGlobalStatus(sender);
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("help")) {
            if (args.length == 2) {
                if (args[1].equalsIgnoreCase("toggle")) {
                    this.sendUsage(sender, "toggle");
                }
                if (args[1].equalsIgnoreCase("status")) {
                    this.sendUsage(sender, "status");
                }
                if (args[1].equalsIgnoreCase("reset")) {
                    this.sendUsage(sender, "reset");
                }
                if (args[1].equalsIgnoreCase("world")) {
                    this.sendUsage(sender, "world");
                }
                if (args[1].equalsIgnoreCase("global")) {
                    this.sendUsage(sender, "global");
                }
            } else {
                this.sendUsage(sender, "help");
            }
        } else {
            this.sendUsage(sender, "help");
        }
        return true;
    }

    private Player getPlayer(CommandSender sender, String player, boolean notify) {
        Player[] players;
        ArrayList<Player> found = new ArrayList<Player>();
        Player[] playerArray = players = this.plugin.getServer().getOnlinePlayers();
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player search = playerArray[n2];
            if (search.getDisplayName().toLowerCase().contains(player.toLowerCase()) || search.getName().toLowerCase().contains(player.toLowerCase())) {
                found.add(search);
            }
            ++n2;
        }
        if (found.size() == 1) {
            return (Player)found.get(0);
        }
        if (found.size() > 1) {
            if (notify) {
                sender.sendMessage("Found " + found.size() + " online players matching that partial name:");
            }
            for (Player p : found) {
                if (!notify) continue;
                sender.sendMessage("- " + p.getDisplayName());
            }
        } else if (notify) {
            PvPLocalisation.display(sender, "", "", "", PvPLocalisation.Strings.PLAYER_NOT_FOUND);
        }
        return null;
    }

    private void getPlayerStatus(CommandSender sender, Player target, String world) {
        if (!(this.plugin.permissionsCheck(sender, "pvptoggle.self.status", true) && sender.getName().equalsIgnoreCase(target.getName()) || this.plugin.permissionsCheck(sender, "pvptoggle.other.status", true) || this.plugin.permissionsCheck(sender, "pvptoggle.admin", true))) {
            PvPLocalisation.display(sender, "", "", "", PvPLocalisation.Strings.NO_PERMISSION);
            return;
        }
        if (target != null && world != null) {
            if (sender.getName().equalsIgnoreCase(target.getName())) {
                if (this.plugin.permissionsCheck((CommandSender)target, "pvptoggle.pvp.force", false)) {
                    PvPLocalisation.display(sender, "", world, PvPLocalisation.Strings.PVP_FORCED.toString(), PvPLocalisation.Strings.PLAYER_CHECK_STATUS);
                } else if (this.plugin.permissionsCheck((CommandSender)target, "pvptoggle.pvp.deny", false)) {
                    PvPLocalisation.display(sender, "", world, PvPLocalisation.Strings.PVP_DENIED.toString(), PvPLocalisation.Strings.PLAYER_CHECK_STATUS);
                } else if (this.plugin.checkPlayerStatus(target, target.getWorld().getName())) {
                    PvPLocalisation.display(sender, "", world, PvPLocalisation.Strings.PVP_ENABLED.toString(), PvPLocalisation.Strings.PLAYER_CHECK_STATUS);
                } else {
                    PvPLocalisation.display(sender, "", world, PvPLocalisation.Strings.PVP_DISABLED.toString(), PvPLocalisation.Strings.PLAYER_CHECK_STATUS);
                }
            } else if (this.plugin.permissionsCheck((CommandSender)target, "pvptoggle.pvp.force", false)) {
                PvPLocalisation.display(sender, target.getName(), world, PvPLocalisation.Strings.PVP_FORCED.toString(), PvPLocalisation.Strings.PLAYER_CHECK_OTHER_STATUS);
            } else if (this.plugin.permissionsCheck((CommandSender)target, "pvptoggle.pvp.deny", false)) {
                PvPLocalisation.display(sender, target.getName(), world, PvPLocalisation.Strings.PVP_DENIED.toString(), PvPLocalisation.Strings.PLAYER_CHECK_OTHER_STATUS);
            } else if (this.plugin.checkPlayerStatus(target, world)) {
                PvPLocalisation.display(sender, target.getName(), world, PvPLocalisation.Strings.PVP_ENABLED.toString(), PvPLocalisation.Strings.PLAYER_CHECK_OTHER_STATUS);
            } else {
                PvPLocalisation.display(sender, target.getName(), world, PvPLocalisation.Strings.PVP_DISABLED.toString(), PvPLocalisation.Strings.PLAYER_CHECK_OTHER_STATUS);
            }
        }
    }

    private void getGlobalStatus(CommandSender sender) {
        if (this.plugin.permissionsCheck(sender, "pvptoggle.global.status", true)) {
            if (((Boolean)this.plugin.getGlobalSetting("enabled")).booleanValue()) {
                PvPLocalisation.display(sender, "", "", PvPLocalisation.Strings.PVP_ENABLED.toString(), PvPLocalisation.Strings.PLAYER_CHECK_GLOBAL_STATUS);
            } else {
                PvPLocalisation.display(sender, "", "", PvPLocalisation.Strings.PVP_DISABLED.toString(), PvPLocalisation.Strings.PLAYER_CHECK_GLOBAL_STATUS);
            }
        } else {
            PvPLocalisation.display(sender, "", "", "", PvPLocalisation.Strings.NO_PERMISSION);
        }
    }

    private void getWorldStatus(CommandSender sender, String worldname) {
        if (this.plugin.permissionsCheck(sender, "pvptoggle.world.status", true)) {
            if (worldname != null) {
                if (this.plugin.getWorldStatus(worldname)) {
                    PvPLocalisation.display(sender, "", worldname, PvPLocalisation.Strings.PVP_ENABLED.toString(), PvPLocalisation.Strings.PLAYER_CHECK_WORLD_STATUS);
                } else {
                    PvPLocalisation.display(sender, "", worldname, PvPLocalisation.Strings.PVP_DISABLED.toString(), PvPLocalisation.Strings.PLAYER_CHECK_WORLD_STATUS);
                }
            }
        } else {
            PvPLocalisation.display(sender, "", "", "", PvPLocalisation.Strings.NO_PERMISSION);
        }
    }

    private void togglePlayer(CommandSender sender, Player player, String worldname, boolean newval) {
        if (player == null || worldname == null) {
            return;
        }
        if (!(this.plugin.permissionsCheck(sender, "pvptoggle.self.toggle", true) && sender.getName().equalsIgnoreCase(player.getName()) || this.plugin.permissionsCheck(sender, "pvptoggle.other.toggle", true))) {
            PvPLocalisation.display(sender, "", "", "", PvPLocalisation.Strings.NO_PERMISSION);
            return;
        }
        if (sender.getName().equalsIgnoreCase(player.getName())) {
            if (newval) {
                this.plugin.setPlayerStatus(player, player.getWorld().getName(), true);
                PvPLocalisation.display(sender, "", player.getWorld().getName(), PvPLocalisation.Strings.PVP_ENABLED.toString(), PvPLocalisation.Strings.PVP_PLAYER_SELF_TOGGLE);
                this.plugin.log.info("[PvPToggle] Player " + player.getDisplayName() + " enabled pvp");
                this.plugin.setLastAction(player, "toggle");
            } else if (!newval) {
                if (this.plugin.checkLastAction(player, "toggle", player.getWorld().getName())) {
                    this.plugin.setPlayerStatus(player, player.getWorld().getName(), false);
                    PvPLocalisation.display(sender, "", player.getWorld().getName(), PvPLocalisation.Strings.PVP_DISABLED.toString(), PvPLocalisation.Strings.PVP_PLAYER_SELF_TOGGLE);
                    this.plugin.log.info("[PvPToggle] Player " + player.getDisplayName() + " disabled pvp");
                } else {
                    PvPLocalisation.display(sender, "", "", "", PvPLocalisation.Strings.PLAYER_COOLDOWN);
                }
            }
        } else {
            String message = null;
            message = newval ? PvPLocalisation.Strings.PVP_ENABLED.toString() : PvPLocalisation.Strings.PVP_DISABLED.toString();
            if (worldname.equalsIgnoreCase("*")) {
                for (World world : this.plugin.getServer().getWorlds()) {
                    this.plugin.setPlayerStatus(player, world.getName(), newval);
                }
                PvPLocalisation.display((CommandSender)player, "", "", message, PvPLocalisation.Strings.PVP_PLAYER_GLOBAL_TOGGLE);
                PvPLocalisation.display(sender, player.getName(), "", message, PvPLocalisation.Strings.PVP_PLAYER_GLOBAL_TOGGLE_SENDER);
            } else {
                this.plugin.setPlayerStatus(player, worldname, newval);
                PvPLocalisation.display((CommandSender)player, "", worldname, message, PvPLocalisation.Strings.PVP_PLAYER_OTHER_TOGGLE);
                PvPLocalisation.display(sender, player.getName(), worldname, message, PvPLocalisation.Strings.PVP_PLAYER_OTHER_TOGGLE_SENDER);
            }
            this.plugin.setLastAction(player, "toggle");
        }
    }

    private void toggleWorld(CommandSender sender, String targetworld, boolean newval) {
        if (!this.plugin.permissionsCheck(sender, "pvptoggle.world.toggle", true) && !this.plugin.permissionsCheck(sender, "pvptoggle.admin", true)) {
            PvPLocalisation.display(sender, "", "", "", PvPLocalisation.Strings.NO_PERMISSION);
            return;
        }
        if (targetworld != null) {
            this.plugin.setWorldStatus(targetworld, newval);
            if (newval) {
                PvPLocalisation.display(sender, "", targetworld, PvPLocalisation.Strings.PVP_ENABLED.toString(), PvPLocalisation.Strings.PVP_WORLD_TOGGLE_SENDER);
            } else {
                PvPLocalisation.display(sender, "", targetworld, PvPLocalisation.Strings.PVP_DISABLED.toString(), PvPLocalisation.Strings.PVP_WORLD_TOGGLE_SENDER);
            }
        }
    }

    private void toggleGlobal(CommandSender sender, boolean newval) {
        if (!this.plugin.permissionsCheck(sender, "pvptoggle.global.toggle", true) && !this.plugin.permissionsCheck(sender, "pvptoggle.admin", true)) {
            PvPLocalisation.display(sender, "", "", "", PvPLocalisation.Strings.NO_PERMISSION);
            return;
        }
        this.plugin.toggleGlobalStatus(newval);
        if (newval) {
            PvPLocalisation.display(sender, "", "", PvPLocalisation.Strings.PVP_ENABLED.toString(), PvPLocalisation.Strings.PVP_GLOBAL_TOGGLE_SENDER);
        } else {
            PvPLocalisation.display(sender, "", "", PvPLocalisation.Strings.PVP_DISABLED.toString(), PvPLocalisation.Strings.PVP_GLOBAL_TOGGLE_SENDER);
        }
    }

    private void resetPlayer(CommandSender sender, Player player, String worldname) {
        if (player == null || worldname == null) {
            return;
        }
        if (!(this.plugin.permissionsCheck(sender, "pvptoggle.self.reset", true) && sender.getName().equalsIgnoreCase(player.getName()) || this.plugin.permissionsCheck(sender, "pvptoggle.other.reset", true) || this.plugin.permissionsCheck(sender, "pvptoggle.admin", true))) {
            PvPLocalisation.display(sender, "", "", "", PvPLocalisation.Strings.NO_PERMISSION);
            return;
        }
        if (worldname.equalsIgnoreCase("*")) {
            for (World world : this.plugin.getServer().getWorlds()) {
                this.plugin.setPlayerStatus(player, world.getName(), this.plugin.getWorldDefault(world.getName()));
            }
            this.plugin.setLastAction(player, "toggle");
            PvPLocalisation.display((CommandSender)player, "", "", "", PvPLocalisation.Strings.PVP_RESET_PLAYER_GLOBAL);
            PvPLocalisation.display(sender, player.getName(), "", "", PvPLocalisation.Strings.PVP_RESET_PLAYER_GLOBAL_SENDER);
        } else {
            this.plugin.setPlayerStatus(player, worldname, this.plugin.getWorldDefault(worldname));
            this.plugin.setLastAction(player, "toggle");
            PvPLocalisation.display((CommandSender)player, "", worldname, "", PvPLocalisation.Strings.PVP_RESET_PLAYER);
            PvPLocalisation.display(sender, player.getName(), worldname, "", PvPLocalisation.Strings.PVP_RESET_PLAYER_SENDER);
        }
    }

    private void resetWorld(CommandSender sender, String worldname, boolean newval) {
        Player[] players;
        if (!this.plugin.permissionsCheck(sender, "pvptoggle.world.reset", true) && !this.plugin.permissionsCheck(sender, "pvptoggle.admin", true)) {
            PvPLocalisation.display(sender, "", "", "", PvPLocalisation.Strings.NO_PERMISSION);
            return;
        }
        Player[] playerArray = players = this.plugin.getServer().getOnlinePlayers();
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            this.plugin.setPlayerStatus(p, worldname, newval);
            this.plugin.setLastAction(p, "toggle");
            if (newval) {
                PvPLocalisation.display((CommandSender)p, "", worldname, PvPLocalisation.Strings.PVP_ENABLED.toString(), PvPLocalisation.Strings.PVP_RESET_WORLD);
            } else {
                PvPLocalisation.display((CommandSender)p, "", worldname, PvPLocalisation.Strings.PVP_DISABLED.toString(), PvPLocalisation.Strings.PVP_RESET_WORLD);
            }
            ++n2;
        }
        if (newval) {
            PvPLocalisation.display(sender, "", worldname, PvPLocalisation.Strings.PVP_ENABLED.toString(), PvPLocalisation.Strings.PVP_RESET_WORLD_SENDER);
        } else {
            PvPLocalisation.display(sender, "", worldname, PvPLocalisation.Strings.PVP_DISABLED.toString(), PvPLocalisation.Strings.PVP_RESET_WORLD_SENDER);
        }
    }

    private void resetGlobal(CommandSender sender) {
        Player[] players;
        if (!this.plugin.permissionsCheck(sender, "pvptoggle.global.reset", true) && !this.plugin.permissionsCheck(sender, "pvptoggle.admin", true)) {
            PvPLocalisation.display(sender, "", "", "", PvPLocalisation.Strings.NO_PERMISSION);
            return;
        }
        Player[] playerArray = players = this.plugin.getServer().getOnlinePlayers();
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            for (World world : this.plugin.getServer().getWorlds()) {
                this.plugin.setPlayerStatus(p, world.getName(), this.plugin.getWorldDefault(world.getName()));
            }
            this.plugin.setLastAction(p, "toggle");
            PvPLocalisation.display((CommandSender)p, "", "", "", PvPLocalisation.Strings.PVP_RESET_GLOBAL);
            ++n2;
        }
        PvPLocalisation.display(sender, "", "", "", PvPLocalisation.Strings.PVP_RESET_GLOBAL_SENDER);
    }

    private void sendUsage(CommandSender sender, String section) {
        sender.sendMessage(ChatColor.RED + "-----------------[ " + ChatColor.GOLD + "PvPToggle v" + this.plugin.getDescription().getVersion() + ChatColor.RED + " ]-----------------");
        ChatColor messagecolour = ChatColor.GOLD;
        if (section.equalsIgnoreCase("help")) {
            sender.sendMessage(messagecolour + "/pvp help toggle " + ChatColor.GRAY + "- \u0418\u041d\u0424\u041e \u043e \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430");
            sender.sendMessage(messagecolour + "/pvp help status " + ChatColor.GRAY + "- \u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u0442\u0435\u043a\u0443\u0449\u0435\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435");
            sender.sendMessage(messagecolour + "/pvp help reset " + ChatColor.GRAY + "- \u0418\u041d\u0424\u041e \u043e \u043a\u043e\u043c\u0430\u043d\u0434\u0435 \u0441\u0431\u0440\u043e\u0441\u0430");
            sender.sendMessage(messagecolour + "/pvp help world " + ChatColor.GRAY + "- \u0418\u041d\u0424\u041e \u043e \u043a\u043e\u043c\u0430\u043d\u0434 \u0432 \u043c\u0438\u0440\u0435");
            sender.sendMessage(messagecolour + "/pvp help global " + ChatColor.GRAY + "- \u0418\u041d\u0424\u041e \u043e \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0445 \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u0430\u0445");
        }
        if (section.equalsIgnoreCase("toggle") || section.equalsIgnoreCase("*")) {
            if (this.plugin.permissionsCheck(sender, "pvptoggle.self.toggle", true)) {
                sender.sendMessage(messagecolour + "/pvp " + ChatColor.GRAY + "- \u0418\u0437\u043c\u0435\u043d\u044f\u0435\u0442 \u0441\u0432\u043e\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 PVP");
                sender.sendMessage(messagecolour + "/pvp on " + ChatColor.GRAY + "- \u0418\u0437\u043c\u0435\u043d\u044f\u0435\u0442 \u0441\u0432\u043e\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u043d\u0430 PVP ON");
                sender.sendMessage(messagecolour + "/pvp off " + ChatColor.GRAY + "- \u0418\u0437\u043c\u0435\u043d\u044f\u0435\u0442 \u0441\u0432\u043e\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u043d\u0430 PVP OFF");
            }
            if (this.plugin.permissionsCheck(sender, "pvptoggle.other.toggle", true)) {
                sender.sendMessage(messagecolour + "/pvp on [player] " + ChatColor.GRAY + "- \u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c PVP \u0434\u043b\u044f \u043e\u043f\u0440\u0435\u0434. \u0438\u0433\u0440\u043e\u043a\u0430 \u0432\u043e \u0432\u0441\u0435\u0445 \u043c\u0438\u0440\u0430\u0445");
                sender.sendMessage(messagecolour + "/pvp on [player] [world] " + ChatColor.GRAY + "- \u0418\u0437\u043c\u0435\u043d\u044f\u0435\u0442 \u0441\u0442\u0430\u0442\u0443\u0441 \u0438\u0433\u0440\u043e\u043a\u0430 \u0432\u043e \u0432\u0441\u0435\u0445 \u043c\u0438\u0440\u0430\u0445");
                sender.sendMessage(messagecolour + "/pvp off [player] " + ChatColor.GRAY + "- \u0418\u0437\u043c\u0435\u043d\u044f\u0435\u0442 \u0441\u0442\u0430\u0442\u0443\u0441 \u043d\u0430 PVP OFF \u0432\u043e \u044d\u0442\u043e\u043c \u043c\u0438\u0440\u0430\u0445");
                sender.sendMessage(messagecolour + "/pvp off [player] [world] " + ChatColor.GRAY + "- \u0418\u0437\u043c\u0435\u043d\u044f\u0435\u0442 \u0441\u0442\u0430\u0442\u0443\u0441 \u043d\u0430 PVP OFF \u0432\u043e \u0432\u0441\u0435\u0445 \u043c\u0438\u0440\u0430\u0445");
            }
        }
        if ((section.equalsIgnoreCase("reset") || section.equalsIgnoreCase("*")) && this.plugin.permissionsCheck(sender, "pvptoggle.other.reset", true)) {
            sender.sendMessage(messagecolour + "/pvp reset [player] " + ChatColor.GRAY + "- \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0438\u0433\u0440\u043e\u043a\u0443 \u0440\u0435\u0436\u0438\u043c\u0430 PVP \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u0434\u043b\u044f \u0432\u0441\u0435\u0445 \u043c\u0438\u0440\u043e\u0432");
            sender.sendMessage(messagecolour + "/pvp reset [player] [world] " + ChatColor.GRAY + "- \u0421\u0431\u0440\u0430\u0441\u044b\u0432\u0430\u0435\u0442 PVP-\u0441\u0442\u0430\u0442\u0443\u0441 \u043d\u0430 \"\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e\" \u0432 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c \u043c\u0438\u0440\u0435");
        }
        if (section.equalsIgnoreCase("status") || section.equalsIgnoreCase("*")) {
            if (this.plugin.permissionsCheck(sender, "pvptoggle.self.status", true)) {
                sender.sendMessage(messagecolour + "/pvp status " + ChatColor.GRAY + "- \u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043c\u043e\u0439 PVP \u0441\u0442\u0430\u0442\u0443\u0441 \u0432 \u044d\u0442\u043e\u043c \u043c\u0438\u0440\u0435");
            }
            if (this.plugin.permissionsCheck(sender, "pvptoggle.other.status", true)) {
                sender.sendMessage(messagecolour + "/pvp status [player] " + ChatColor.GRAY + "- \u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c PVP \u0441\u0442\u0430\u0442\u0443\u0441 \u0438\u0433\u0440\u043e\u043a\u0430 \u0432 \u044d\u0442\u043e\u043c \u043c\u0438\u0440\u0435");
                sender.sendMessage(messagecolour + "/pvp status [player] [world] " + ChatColor.GRAY + "- \u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c PVP \u0441\u0442\u0430\u0442\u0443\u0441 \u0432\u043e \u0432\u0441\u0435\u0445 \u043c\u0438\u0440\u0430\u0445");
            }
        }
        if (section.equalsIgnoreCase("world") || section.equalsIgnoreCase("*")) {
            if (this.plugin.permissionsCheck(sender, "pvptoggle.world.toggle", true)) {
                sender.sendMessage(messagecolour + "/pvp w:[world] on " + ChatColor.GRAY + "- \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c PVP \u0441\u0442\u0430\u0442\u0443\u0441 \u0432 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c \u043c\u0438\u0440\u0435 \u043d\u0430 ON");
                sender.sendMessage(messagecolour + "/pvp w:[world] off " + ChatColor.GRAY + "- \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c PVP \u0441\u0442\u0430\u0442\u0443\u0441 \u0432 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c \u043c\u0438\u0440\u0435 \u043d\u0430 OFF");
            }
            if (this.plugin.permissionsCheck(sender, "pvptoggle.world.reset", true)) {
                sender.sendMessage(messagecolour + "/pvp w:[world] reset " + ChatColor.GRAY + "- \u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c PVP \u0441\u0442\u0430\u0442\u0443\u0441 \u0432\u0441\u0435\u0445 \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u0432 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c \u043c\u0438\u0440\u0435");
            }
            if (this.plugin.permissionsCheck(sender, "pvptoggle.world.status", true)) {
                sender.sendMessage(messagecolour + "/pvp w:[world] " + ChatColor.GRAY + "- \u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c PVP \u0441\u0442\u0430\u0442\u0443\u0441 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0433\u043e \u043c\u0438\u0440\u0430");
                sender.sendMessage(messagecolour + "/pvp w:[world] status " + ChatColor.GRAY + "- \u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c PVP \u0441\u0442\u0430\u0442\u0443\u0441 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0433\u043e \u043c\u0438\u0440\u0430");
            }
        }
        if (section.equalsIgnoreCase("global") || section.equalsIgnoreCase("*")) {
            if (this.plugin.permissionsCheck(sender, "pvptoggle.global.toggle", true)) {
                sender.sendMessage(messagecolour + "/pvp global on " + ChatColor.GRAY + "- \u0412\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e\u0435 PVP");
                sender.sendMessage(messagecolour + "/pvp global off " + ChatColor.GRAY + "- \u0412\u044b\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e\u0435 PvP");
            }
            if (this.plugin.permissionsCheck(sender, "pvptoggle.global.reset", true)) {
                sender.sendMessage(messagecolour + "/pvp global reset " + ChatColor.GRAY + "- \u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c PVP \u0441\u0442\u0430\u0442\u0443\u0441 \u0432\u0441\u0435\u0445 \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u043a\u043e\u0433\u0434\u0430 \u043e\u043d\u0438 \u0431\u0443\u0434\u0443\u0442 \u043b\u043e\u0433\u0438\u043d\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \"\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e\"");
            }
            if (this.plugin.permissionsCheck(sender, "pvptoggle.global.reset", true)) {
                sender.sendMessage(messagecolour + "/pvp global " + ChatColor.GRAY + "- Shows global PvP status");
                sender.sendMessage(messagecolour + "/pvp global status " + ChatColor.GRAY + "- Shows global PvP status");
            }
        }
    }

    public static Boolean checkNewValue(String string) {
        Boolean enable = null;
        if (string.equalsIgnoreCase("on") || string.equalsIgnoreCase("enable")) {
            enable = true;
        } else if (string.equalsIgnoreCase("off") || string.equalsIgnoreCase("disable")) {
            enable = false;
        }
        return enable;
    }

    private String isWorld(CommandSender sender, String worldname, boolean notify) {
        String output = this.plugin.checkWorldName(worldname);
        if (output == null && notify) {
            PvPLocalisation.display(sender, null, null, null, PvPLocalisation.Strings.WORLD_NOT_FOUND);
        }
        return output;
    }

    private String isWorld(CommandSender sender, String worldname) {
        return this.isWorld(sender, worldname, true);
    }
}

