/*
 * Decompiled with CFR 0.152.
 */
package com.sleelin.pvptoggle;

import com.sleelin.pvptoggle.PvPToggle;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class PvPLocalisation {
    private static FileConfiguration customConfig = null;
    private static File customConfigFile = null;
    private static PvPToggle plugin = null;

    public static void loadProcedure(PvPToggle plugin) {
        PvPLocalisation.plugin = plugin;
        PvPLocalisation.reloadCustomConfig();
        PvPLocalisation.writeDefaults();
        PvPLocalisation.loadValues();
    }

    private static void writeDefaults() {
        Strings[] stringsArray = Strings.values();
        int n = stringsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Strings string = stringsArray[n2];
            if (!PvPLocalisation.getCustomConfig().isSet(string.name())) {
                PvPLocalisation.getCustomConfig().set(string.name(), (Object)string.text);
            }
            ++n2;
        }
        PvPLocalisation.saveCustomConfig();
    }

    private static void loadValues() {
        Strings[] stringsArray = Strings.values();
        int n = stringsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Strings string = stringsArray[n2];
            string.text = PvPLocalisation.getCustomConfig().getString(string.name(), string.text);
            ++n2;
        }
    }

    private static String replaceVars(String input, String[] search, String[] replace) {
        if (search.length != replace.length) {
            return "";
        }
        int i = 0;
        while (i < search.length) {
            if (replace[i] != null) {
                input = input.replace(search[i], replace[i]);
            }
            ++i;
        }
        return input.replaceAll("(&([a-f0-9]))", "\u00a7$2");
    }

    public static void display(CommandSender sender, String target, String world, String status, Strings string) {
        String[] search = new String[]{"%sender%", "%target%", "%world%", "%status%"};
        String[] replace = new String[]{sender.getName(), target, world, status};
        sender.sendMessage(PvPLocalisation.replaceVars(string.toString(), search, replace));
    }

    private static void reloadCustomConfig() {
        if (customConfigFile == null) {
            customConfigFile = new File(plugin.getDataFolder(), "localisations.yml");
        }
        customConfig = YamlConfiguration.loadConfiguration((File)customConfigFile);
    }

    private static FileConfiguration getCustomConfig() {
        if (customConfig == null) {
            PvPLocalisation.reloadCustomConfig();
        }
        return customConfig;
    }

    private static void saveCustomConfig() {
        if (customConfig == null || customConfigFile == null) {
            return;
        }
        try {
            customConfig.save(customConfigFile);
        }
        catch (IOException ex) {
            Logger.getLogger(JavaPlugin.class.getName()).log(Level.SEVERE, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433 \u0432 " + customConfigFile, ex);
        }
    }

    public static enum Strings {
        CONSOLE_ERROR("&cCannot run this command from the console!"),
        NO_PERMISSION("&c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u044d\u0442\u043e\u0433\u043e!"),
        PLAYER_NOT_FOUND("&c\u041d\u0435\u0442 \u0442\u0430\u043a\u043e\u0433\u043e \u0438\u0433\u0440\u043e\u043a\u0430!"),
        PLAYER_COOLDOWN("&c\u0412\u044b \u0442\u043e\u043b\u044c\u043a\u043e \u0447\u0442\u043e \u0431\u044b\u043b\u0438 \u0432 \u0431\u043e\u044e, \u0435\u0449\u0451 \u0440\u0430\u043d\u043e \u0435\u0433\u043e \u0432\u044b\u043a\u043b\u044e\u0447\u0430\u0442\u044c!"),
        PLAYER_WARMUP("&c\u0412\u044b \u0432\u043a\u043b\u044e\u0447\u0438\u043b\u0438 PVP!"),
        PLAYER_AUTOENABLE("&6PvP \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0432\u043a\u043b\u044e\u0447\u0430\u0435\u0442\u0441\u044f \u0432 \u0434\u0440\u0430\u043a\u0435!"),
        PLAYER_CHECK_STATUS("&6PvP \u0441\u0442\u0430\u0442\u0443\u0441 \u0432 \u043c\u0438\u0440\u0435 %world%: %status%"),
        PLAYER_CHECK_OTHER_STATUS("&6%target%'s PvP \u0441\u0442\u0430\u0442\u0443\u0441 \u0432 \u043c\u0438\u0440\u0435 %world%: %status%"),
        PLAYER_CHECK_WORLD_STATUS("&6\u0412\u0441\u0435\u043c\u0438\u0440\u043d\u044b\u0439 PVP \u0441\u0442\u0430\u0442\u0443\u0441 \u043d\u0430  %world%: %status%"),
        PLAYER_CHECK_GLOBAL_STATUS("&6\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0439 PVP \u0441\u0442\u0430\u0442\u0443\u0441: %status%"),
        PVP_ENABLED("\u0432\u043a\u043b\u044e\u0447\u0435\u043d"),
        PVP_DISABLED("\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d"),
        PVP_FORCED("\u043f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e"),
        PVP_DENIED("\u043e\u0442\u043a\u0430\u0437\u0430\u043d\u043e"),
        PVP_DENY_DISABLED("&c\u0412\u044b \u0432\u044b\u043a\u043b\u044e\u0447\u0438\u043b\u0438 PVP!"),
        PVP_DENY_OPPONENT("&c%target% \u0432\u044b\u043a\u043b\u044e\u0447\u0438\u043b PVP!"),
        PVP_DENY_WORLD("&cPvP \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u0432 \u043c\u0438\u0440\u0435 %world%!"),
        PVP_DENY_GLOBAL("&c\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e\u0435 PVP \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u043e!"),
        PVP_PLAYER_SELF_TOGGLE("&6PvP %status% \u0432 \u043c\u0438\u0440\u0435 %world%!"),
        PVP_PLAYER_OTHER_TOGGLE("&6PvP %status% \u0432 \u043c\u0438\u0440\u0435 %world% by %sender%!"),
        PVP_PLAYER_GLOBAL_TOGGLE("&6PvP %status% \u0432\u043e \u0432\u0441\u0435\u0445 \u043c\u0438\u0440\u0430\u0445 by %sender%!"),
        PVP_WORLD_TOGGLE(""),
        PVP_GLOBAL_TOGGLE(""),
        PVP_PLAYER_OTHER_TOGGLE_SENDER("&6\u0423\u0441\u043f\u0435\u0448\u043d\u043e %status% PvP \u0434\u043b\u044f %target% \u0432 \u043c\u0438\u0440\u0435 %world%!"),
        PVP_PLAYER_GLOBAL_TOGGLE_SENDER("&6\u0423\u0441\u043f\u0435\u0448\u043d\u043e %status% PvP \u0434\u043b\u044f \u0438\u0433\u0440\u043e\u043a\u0430 %target% \u0432\u043e \u0432\u0441\u0435\u0445 \u043c\u0438\u0440\u0430\u0445!"),
        PVP_WORLD_TOGGLE_SENDER("&6\u0423\u0441\u043f\u0435\u0448\u043d\u043e %status% \u0432\u0441\u0435\u043c\u0438\u0440\u043d\u043e\u0433\u043e PvP \u0432 %world%"),
        PVP_GLOBAL_TOGGLE_SENDER("&6\u0423\u0441\u043f\u0435\u0448\u043d\u043e %status% \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0439 PvP!"),
        PVP_RESET_PLAYER("&6PvP \u0441\u0442\u0430\u0442\u0443\u0441 \u0441\u0431\u0440\u043e\u0448\u0435\u043d \u0434\u043b\u044f  \"\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e\" \u0432 \u043c\u0438\u0440\u0435 %world% by %sender%"),
        PVP_RESET_PLAYER_GLOBAL("&6PvP \u0441\u0442\u0430\u0442\u0443\u0441 \u0441\u0431\u0440\u043e\u0448\u0435\u043d \u043d\u0430 \"\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e\" \u0434\u043b\u044f \u0432\u0441\u0435\u0445 \u043c\u0438\u0440\u043e\u0432 by %sender%"),
        PVP_RESET_WORLD("&6PvP %status% \u0432 \u043c\u0438\u0440\u0435 %world% by %sender%!"),
        PVP_RESET_GLOBAL("&6\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e\u0435 PvP \u0441\u0431\u0440\u043e\u0448\u0435\u043d\u043d\u043e \u0432\u043e \u0432\u0441\u0435\u0445 \u043c\u0438\u0440\u0430\u0445 by %sender%!"),
        PVP_RESET_PLAYER_SENDER("&6\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u0431\u0440\u043e\u0448\u0435\u043d PVP \u0441\u0442\u0430\u0442\u0443\u0441 \u043d\u0430 %target% \u043d\u0430 \"\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e\" \u0434\u043b\u044f \u043c\u0438\u0440\u0430 %world%!"),
        PVP_RESET_PLAYER_GLOBAL_SENDER("&6\u0423\u0441\u043f\u0435\u0448\u043d\u044b\u0439 \u0441\u0431\u0440\u043e\u0441 PvP \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0441 %target% \u043d\u0430 \"\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e\""),
        PVP_RESET_WORLD_SENDER("&6\u0423\u0441\u043f\u0435\u0448\u043d\u044b\u0439 \u0441\u0431\u0440\u043e\u0441 PvP \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0432\u0441\u0435\u0445 \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u043d\u0430 %status% \u0432 \u043c\u0438\u0440\u0435 %world%"),
        PVP_RESET_GLOBAL_SENDER("&6\u0423\u0441\u043f\u0435\u0448\u043d\u044b\u0439 \u0441\u0431\u0440\u043e\u0441 PvP \u0432\u0441\u0435\u0445 \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u0434\u043b\u044f \u0432\u0441\u0435\u0445 \u043c\u0438\u0440\u043e\u0432!"),
        WORLD_NOT_FOUND("&cNo world matching that name!");

        private String text;

        private Strings(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

