/*
 * Decompiled with CFR 0.152.
 */
package com.sleelin.pvptoggle;

import com.nijiko.permissions.PermissionHandler;
import com.nijikokun.bukkit.Permissions.Permissions;
import com.sleelin.pvptoggle.PvPCommandHandler;
import com.sleelin.pvptoggle.PvPLocalisation;
import com.sleelin.pvptoggle.listeners.EntityListener;
import com.sleelin.pvptoggle.listeners.PlayerListener;
import com.sleelin.pvptoggle.listeners.WorldListener;
import java.net.URL;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PvPToggle
extends JavaPlugin {
    public Logger log = Logger.getLogger("Minecraft");
    private Runnable updateThread;
    private int updateId = -1;
    private static final String RSS_URL = "http://dev.bukkit.org/server-mods/PvPToggle/files.rss";
    private static String version;
    private static String name;
    private static PermissionHandler permissionHandler;
    private final PlayerListener playerListener = new PlayerListener(this);
    private final EntityListener entityListener = new EntityListener(this);
    private final WorldListener worldListener = new WorldListener(this);
    private HashMap<String, Object> globalsettings = new HashMap();
    private HashMap<String, PvPWorld> worlds = new HashMap();
    private HashMap<Player, PvPAction> lastaction = new HashMap();

    public void onEnable() {
        this.log.info("[" + this.getDescription().getName() + "] Loading...");
        this.loadProcedure();
        PvPLocalisation.loadProcedure(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.playerListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.entityListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.worldListener, (Plugin)this);
        version = this.getDescription().getVersion();
        name = this.getDescription().getName();
        this.startUpdateThread();
        if (((String)this.globalsettings.get("command")).equalsIgnoreCase("tpvp") || ((String)this.globalsettings.get("command")).equalsIgnoreCase("pvpt")) {
            this.getCommand((String)this.globalsettings.get("command")).setExecutor((CommandExecutor)new PvPCommandHandler(this));
        } else {
            this.getCommand("pvp").setExecutor((CommandExecutor)new PvPCommandHandler(this));
        }
        System.out.println("[" + this.getDescription().getName() + "] v" + this.getDescription().getVersion() + " enabled!");
    }

    public void onDisable() {
        this.stopUpdateThread();
        this.worlds.clear();
        this.globalsettings.clear();
        this.lastaction.clear();
        this.log.info("[PvPToggle] \u0412\u044b\u043a\u043b\u044e\u0447\u0435\u043d");
    }

    public PvPToggle getHandler() {
        return this;
    }

    private void loadProcedure() {
        if (!this.getConfig().isSet("plugin.enabled")) {
            this.getConfig().set("plugin.enabled", (Object)(!this.getConfig().getBoolean("globalDisabled", false) ? 1 : 0));
        }
        if (!this.getConfig().isSet("plugin.debug")) {
            this.getConfig().set("plugin.debug", (Object)this.getConfig().getBoolean("debug", false));
        }
        if (!this.getConfig().isSet("plugin.updateinterval")) {
            this.getConfig().set("plugin.updateinterval", (Object)this.getConfig().getInt("updateinterval", 21600));
        }
        if (!this.getConfig().isSet("plugin.command")) {
            this.getConfig().set("plugin.command", (Object)"pvp");
        }
        for (World world : this.getServer().getWorlds()) {
            if (!this.getConfig().isSet("worlds." + world.getName() + ".enabled")) {
                this.getConfig().set("worlds." + world.getName() + ".enabled", (Object)this.getConfig().getBoolean("worlds." + world.getName() + ".pvpenabled", true));
            }
            if (!this.getConfig().isSet("worlds." + world.getName() + ".default")) {
                this.getConfig().set("worlds." + world.getName() + ".default", (Object)this.getConfig().getBoolean("worlds." + world.getName() + ".logindefault", true));
            }
            if (!this.getConfig().isSet("worlds." + world.getName() + ".cooldown")) {
                this.getConfig().set("worlds." + world.getName() + ".cooldown", (Object)this.getConfig().getInt("cooldown", 0));
            }
            if (!this.getConfig().isSet("worlds." + world.getName() + ".warmup")) {
                this.getConfig().set("worlds." + world.getName() + ".warmup", (Object)this.getConfig().getInt("warmup", 0));
            }
            this.getConfig().set("worlds." + world.getName().toString() + ".pvpenabled", null);
            this.getConfig().set("worlds." + world.getName().toString() + ".logindefault", null);
        }
        this.getConfig().set("cooldown", null);
        this.getConfig().set("warmup", null);
        this.getConfig().set("globalDisabled", null);
        this.getConfig().set("debug", null);
        this.getConfig().set("updateinterval", null);
        this.saveConfig();
        this.globalsettings.put("enabled", this.getConfig().getBoolean("plugin.enabled", true));
        this.globalsettings.put("debug", this.getConfig().getBoolean("plugin.debug", false));
        this.globalsettings.put("updateinterval", this.getConfig().getInt("plugin.updateinterval", 21600));
        this.globalsettings.put("command", this.getConfig().getString("plugin.command", "pvp"));
        this.globalsettings.put("citizens", false);
        for (World world : this.getServer().getWorlds()) {
            this.loadWorld(world);
        }
        Player[] playerArray = this.getServer().getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            this.lastaction.put(player, new PvPAction(0L, "login"));
            ++n2;
        }
        if (this.getServer().getPluginManager().getPlugin("Permissions") != null) {
            if (!this.getServer().getPluginManager().getPlugin("Permissions").getDescription().getVersion().equalsIgnoreCase("2.7.7")) {
                permissionHandler = ((Permissions)this.getServer().getPluginManager().getPlugin("Permissions")).getHandler();
                this.log.info("[" + this.getDescription().getName() + "] Legacy Permissions " + this.getServer().getPluginManager().getPlugin("Permissions").getDescription().getVersion() + " detected");
            } else {
                this.log.info("[" + this.getDescription().getName() + "] Permissions bridge detected, using SuperPerms instead!");
            }
        } else {
            this.log.info("[" + this.getDescription().getName() + "] Ispol'zuite SuperPerms dlea izmenenia permissions");
        }
        if (this.getServer().getPluginManager().getPlugin("Citizens") != null) {
            this.globalsettings.put("citizens", true);
            this.log.info("[" + this.getDescription().getName() + "] Naiden plugin Citizens ");
        }
    }

    public void loadWorld(World world) {
        PvPWorld pvpworld = new PvPWorld();
        pvpworld.cooldown = this.getConfig().getInt("worlds." + world.getName() + ".cooldown", 0);
        pvpworld.warmup = this.getConfig().getInt("worlds." + world.getName() + ".warmup", 0);
        pvpworld.enabled = this.getConfig().getBoolean("worlds." + world.getName() + ".enabled", true);
        pvpworld.logindefault = this.getConfig().getBoolean("worlds." + world.getName() + ".default", true);
        Player[] playerArray = this.getServer().getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            pvpworld.players.put(player, pvpworld.logindefault);
            ++n2;
        }
        this.worlds.put(world.getName(), pvpworld);
        this.log.info("[" + this.getDescription().getName() + "] naiden i zagrujen mir  " + world.getName());
    }

    protected void setWorldStatus(String world, boolean enabled) {
        this.worlds.get((Object)world).enabled = enabled;
    }

    public boolean getWorldStatus(String world) {
        if (world != null) {
            return true;
        }
        return this.worlds.get((Object)world).enabled;
    }

    public boolean getWorldDefault(String world) {
        if (world != null) {
            return true;
        }
        return this.worlds.get((Object)world).logindefault;
    }

    public String checkWorldName(String targetworld) {
        String output = null;
        for (World world : this.getServer().getWorlds()) {
            if (!world.getName().toLowerCase().contains(targetworld.toLowerCase())) continue;
            output = world.getName();
            break;
        }
        return output;
    }

    public void setPlayerStatus(Player player, String world, boolean status) {
        if (this.checkWorldName(world) != null && player != null) {
            this.worlds.get((Object)this.checkWorldName((String)world)).players.put(player, status);
        }
    }

    public boolean checkPlayerStatus(Player player, String world) {
        if (this.permissionsCheck((CommandSender)player, "pvptoggle.pvp.force", false)) {
            return true;
        }
        if (this.permissionsCheck((CommandSender)player, "pvptoggle.pvp.deny", false)) {
            return false;
        }
        if (!this.worlds.get((Object)world).players.containsKey(player)) {
            this.lastaction.put(player, new PvPAction(0L, "login"));
            this.worlds.get((Object)world).players.put(player, this.worlds.get((Object)world).logindefault);
        }
        return this.worlds.get((Object)world).players.get(player);
    }

    public Object getGlobalSetting(String setting) {
        return this.globalsettings.get(setting);
    }

    protected void setGlobalSetting(String setting, Object value) {
        this.globalsettings.put(setting, value);
    }

    protected void toggleGlobalStatus(Boolean newval) {
        this.setGlobalSetting("enabled", newval);
    }

    public Boolean checkGlobalStatus() {
        return (Boolean)this.globalsettings.get("enabled");
    }

    public void setLastAction(Player player, String action) {
        this.lastaction.put(player, new PvPAction(new GregorianCalendar().getTime().getTime(), action));
    }

    public boolean checkLastAction(Player player, String action, String world) {
        GregorianCalendar cal = new GregorianCalendar();
        Long difference = cal.getTime().getTime() - this.lastaction.get((Object)player).time;
        int before = 0;
        if (action.equalsIgnoreCase("combat")) {
            if (this.lastaction.get((Object)player).action.equalsIgnoreCase("toggle")) {
                before = difference.compareTo((long)this.worlds.get((Object)world).warmup * 1000L);
            }
        } else if (action.equalsIgnoreCase("toggle") && this.lastaction.get((Object)player).action.equalsIgnoreCase("combat")) {
            before = difference.compareTo((long)this.worlds.get((Object)world).cooldown * 1000L);
        }
        return before >= 0;
    }

    public boolean permissionsCheck(CommandSender sender, String permissions, boolean opdefault) {
        boolean haspermissions = opdefault;
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (((Boolean)this.globalsettings.get("debug")).booleanValue()) {
            this.log.info(String.valueOf(player.getName().toString()) + "/" + permissions + "/Start: " + haspermissions);
        }
        if (permissionHandler != null) {
            haspermissions = permissionHandler.has(player, permissions);
            if (((Boolean)this.globalsettings.get("debug")).booleanValue()) {
                this.log.info(String.valueOf(player.getName().toString()) + "/" + permissions + "/LegPerms: " + haspermissions);
            }
            if (permissionHandler.has(player, "*")) {
                haspermissions = opdefault;
            }
        } else {
            haspermissions = player.hasPermission(permissions);
            if (((Boolean)this.globalsettings.get("debug")).booleanValue()) {
                this.log.info(String.valueOf(player.getName().toString()) + "/" + permissions + "/Before*: " + haspermissions);
            }
            if (player.hasPermission("*")) {
                haspermissions = opdefault;
            }
            if (((Boolean)this.globalsettings.get("debug")).booleanValue()) {
                this.log.info(String.valueOf(player.getName().toString()) + "/" + permissions + "/After*: " + haspermissions);
            }
        }
        if (((Boolean)this.globalsettings.get("debug")).booleanValue()) {
            this.log.info(String.valueOf(player.getName().toString()) + "/" + permissions + "/Final: " + haspermissions);
        }
        return haspermissions;
    }

    private void startUpdateThread() {
        if ((Integer)this.globalsettings.get("updateinterval") == 0) {
            return;
        }
        if (this.updateThread == null) {
            this.updateThread = new Runnable(){

                @Override
                public void run() {
                    String checkVersion = PvPToggle.this.updateCheck(version);
                    if (!checkVersion.equalsIgnoreCase("[v" + version + "]")) {
                        PvPToggle.this.log.info("[" + name + "] Naidena novaia versia: " + checkVersion + " (u vas [v" + version + "])");
                        PvPToggle.this.log.info("[" + name + "] Posetite http://dev.bukkit.org/server-mods/" + name + "/ 4tob ska4at' !");
                    }
                }
            };
        }
        this.updateId = this.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this, this.updateThread, 100L, (long)((Integer)this.globalsettings.get("updateinterval") * 20));
    }

    private void stopUpdateThread() {
        if (this.updateId != -1) {
            this.getServer().getScheduler().cancelTask(this.updateId);
            this.updateId = -1;
        }
    }

    public String updateCheck(String currentVersion) {
        try {
            URL url = new URL(RSS_URL);
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(url.openConnection().getInputStream());
            doc.getDocumentElement().normalize();
            NodeList nodes = doc.getElementsByTagName("item");
            Node firstNode = nodes.item(0);
            if (firstNode.getNodeType() == 1) {
                Element firstElement = (Element)firstNode;
                NodeList firstElementTagName = firstElement.getElementsByTagName("title");
                Element firstNameElement = (Element)firstElementTagName.item(0);
                NodeList firstNodes = firstNameElement.getChildNodes();
                return firstNodes.item(0).getNodeValue();
            }
        }
        catch (Exception e) {
            return currentVersion;
        }
        return currentVersion;
    }

    public class PvPAction {
        Long time;
        String action;

        public PvPAction(Long itime, String iaction) {
            this.time = itime;
            this.action = iaction;
        }
    }

    public class PvPWorld {
        int cooldown;
        int warmup;
        boolean enabled;
        boolean logindefault;
        HashMap<Player, Boolean> players = new HashMap();
    }
}

