/*
 * Decompiled with CFR 0.152.
 */
package com.sleelin.pvptoggle.listeners;

import com.sleelin.pvptoggle.PvPLocalisation;
import com.sleelin.pvptoggle.PvPToggle;
import net.citizensnpcs.api.CitizensManager;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PotionSplashEvent;

public class EntityListener
implements Listener {
    public static PvPToggle plugin;

    public EntityListener(PvPToggle instance) {
        plugin = instance;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (event instanceof EntityDamageByEntityEvent) {
                boolean proceed = false;
                Player damager = null;
                EntityDamageByEntityEvent edbye = (EntityDamageByEntityEvent)event;
                if (edbye.getDamager() instanceof Projectile) {
                    Projectile projectile = (Projectile)edbye.getDamager();
                    if (projectile.getShooter() instanceof Player) {
                        damager = (Player)projectile.getShooter();
                        proceed = true;
                    }
                } else if (edbye.getDamager() instanceof Player) {
                    damager = (Player)edbye.getDamager();
                    proceed = true;
                }
                if (((Boolean)plugin.getGlobalSetting("citizens")).booleanValue() && CitizensManager.isNPC((Entity)player)) {
                    proceed = false;
                }
                if (proceed) {
                    this.eventMagic(player, damager, (Event)event, "EntityDamage", true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void PotionHit(PotionSplashEvent event) {
        if (event.isCancelled()) {
            return;
        }
        boolean firstdamage = true;
        ThrownPotion potion = event.getPotion();
        if (potion.getShooter() instanceof Player) {
            Player damager = (Player)potion.getShooter();
            for (LivingEntity entity : event.getAffectedEntities()) {
                if (!(entity instanceof Player) || ((Player)entity).equals(damager)) continue;
                this.eventMagic((Player)entity, damager, (Event)event, "PotionSplash", firstdamage);
                firstdamage = false;
            }
        }
    }

    private void eventMagic(Player player, Player damager, Event event, String type, boolean first) {
        boolean cancellable = false;
        boolean genabled = (Boolean)plugin.getGlobalSetting("enabled");
        if (!plugin.getWorldStatus(player.getWorld().getName()) || !genabled) {
            if (!plugin.getWorldStatus(player.getWorld().getName()) && first) {
                PvPLocalisation.display((CommandSender)damager, "", player.getWorld().getName(), "", PvPLocalisation.Strings.PVP_DENY_WORLD);
            }
            if (!genabled && first) {
                PvPLocalisation.display((CommandSender)damager, "", "", "", PvPLocalisation.Strings.PVP_DENY_GLOBAL);
            }
            cancellable = true;
        }
        if (!plugin.permissionsCheck((CommandSender)player, "pvptoggle.pvp.force", false)) {
            boolean targetenabled = plugin.checkPlayerStatus(player, player.getWorld().getName());
            boolean damagerenabled = plugin.checkPlayerStatus(damager, player.getWorld().getName());
            if (!plugin.checkLastAction(damager, "combat", damager.getWorld().getName()) && !plugin.permissionsCheck((CommandSender)damager, "pvptoggle.pvp.bypasswarmup", false)) {
                if (first) {
                    PvPLocalisation.display((CommandSender)damager, "", "", "", PvPLocalisation.Strings.PLAYER_WARMUP);
                }
                cancellable = true;
            }
            if (plugin.permissionsCheck((CommandSender)damager, "pvptoggle.pvp.autoenable", false) && !damagerenabled) {
                plugin.setPlayerStatus(damager, damager.getWorld().getName(), true);
                damagerenabled = true;
                PvPLocalisation.display((CommandSender)damager, "", "", "", PvPLocalisation.Strings.PLAYER_AUTOENABLE);
            }
            if (!targetenabled || !damagerenabled) {
                PvPLocalisation.Strings message = null;
                if (!targetenabled) {
                    message = PvPLocalisation.Strings.PVP_DENY_OPPONENT;
                }
                if (!damagerenabled) {
                    message = PvPLocalisation.Strings.PVP_DENY_DISABLED;
                }
                if (first) {
                    PvPLocalisation.display((CommandSender)damager, player.getName(), player.getWorld().getName(), "", message);
                }
                cancellable = true;
            } else {
                plugin.setLastAction(damager, "combat");
                plugin.setLastAction(player, "combat");
            }
        }
        if (cancellable) {
            if (type.equalsIgnoreCase("EntityDamage")) {
                ((EntityDamageEvent)event).setCancelled(true);
            } else if (type.equalsIgnoreCase("PotionSplash")) {
                ((PotionSplashEvent)event).setCancelled(true);
            }
        }
    }
}

